proc tabulate data = ghpb08;
TITLE 'Table A6. Balance Sheet of Health Plans with 100 or more Participants & Trusts';
TITLE2 'by type of insurance and plan, 2008';
TITLE3 '(numbers in millions)';
class ent2 INS3;
var CAST_AST 
	RECEIVABLES_AST
	GOVT_SEC_AST
	DEBT_INST_AST
	STOCK_AST
	PART_JOINT_INT_AST
	REAL_ESTATE_AST
	LOANS_AST
	DFE_AST
	REG_INVST_CO_AST
	INS_CO_GEN_AST
	OTHER_AST TOT_ASSETS_EOY_AMT IOH_ASST;
LABEL TOT_ASSETS_EOY_AMT ='TOTAL ASSETS';
LABEL CAST_AST ='Cash';
LABEL RECEIVABLES_AST='Receivables';
LABEL GOVT_SEC_AST='US Government Securities';
LABEL DEBT_INST_AST='Debt Instruments';
LABEL STOCK_AST='Stock';
LABEL PART_JOINT_INT_AST='Partnership/Joint venture interests';
LABEL REAL_ESTATE_AST='Real Estate';
LABEL LOANS_AST='Loans';
LABEL DFE_AST='Assets in direct filing entities';
LABEL REG_INVST_CO_AST='Assets in registered investment companies';
LABEL INS_CO_GEN_AST='Assets in insurance co. general accounts';
LABEL OTHER_AST='Other';
table (TOT_ASSETS_EOY_AMT 
	CAST_AST 
	RECEIVABLES_AST
	GOVT_SEC_AST
	DEBT_INST_AST
	STOCK_AST
	PART_JOINT_INT_AST
	REAL_ESTATE_AST
	LOANS_AST
	DFE_AST
	REG_INVST_CO_AST
	INS_CO_GEN_AST
	OTHER_AST IOH_ASST)*sum=' '*f=m12f., 
(all='Total' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;
